/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.a;
import org.apache.commons.logging.b;
import org.apache.commons.logging.c;
import org.apache.commons.logging.d;
import org.apache.commons.logging.e;
import org.apache.commons.logging.f;

public abstract class LogFactory {
    public static final String PRIORITY_KEY = "priority";
    public static final String TCCL_KEY = "use_tccl";
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    public static final String DIAGNOSTICS_DEST_PROPERTY = "org.apache.commons.logging.diagnostics.dest";
    private static PrintStream a;
    private static final String b;
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "org.apache.commons.logging.LogFactory.HashtableImpl";
    private static final ClassLoader c;
    protected static Hashtable factories;
    protected static volatile LogFactory nullClassLoaderFactory;
    private static Class d;

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1);

    public abstract Log getInstance(String var1);

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    private static final Hashtable a() {
        Hashtable hashtable;
        block7: {
            String string;
            hashtable = null;
            try {
                string = LogFactory.a(HASHTABLE_IMPLEMENTATION_PROPERTY, null);
            }
            catch (SecurityException securityException) {
                string = null;
            }
            if (string == null) {
                string = "org.apache.commons.logging.impl.WeakHashtable";
            }
            try {
                Class<?> clazz = Class.forName(string);
                hashtable = (Hashtable)clazz.newInstance();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                LogFactory.handleThrowable(throwable);
                if ("org.apache.commons.logging.impl.WeakHashtable".equals(string)) break block7;
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.c("[ERROR] LogFactory: Load of custom hashtable failed");
                }
                System.err.println("[ERROR] LogFactory: Load of custom hashtable failed");
            }
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    private static String b(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    protected static void handleThrowable(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    public static LogFactory getFactory() {
        String string;
        Object object;
        ClassLoader classLoader;
        Properties properties;
        Enumeration<?> enumeration;
        LogFactory logFactory;
        ClassLoader classLoader2;
        block41: {
            classLoader2 = (ClassLoader)AccessController.doPrivileged(new a());
            if (classLoader2 == null && LogFactory.isDiagnosticsEnabled()) {
                LogFactory.c("Context classloader is null.");
            }
            if ((logFactory = (enumeration = classLoader2) == null ? nullClassLoaderFactory : (LogFactory)factories.get(enumeration)) != null) {
                return logFactory;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.c("[LOOKUP] LogFactory implementation requested for the first time for context classloader " + LogFactory.objectId(classLoader2));
                LogFactory.a("[LOOKUP] ", classLoader2);
            }
            properties = LogFactory.a(classLoader2, FACTORY_PROPERTIES);
            classLoader = classLoader2;
            if (properties != null && (enumeration = properties.getProperty(TCCL_KEY)) != null && !Boolean.valueOf((String)((Object)enumeration)).booleanValue()) {
                classLoader = c;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.c("[LOOKUP] Looking for system property [org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
            }
            try {
                enumeration = LogFactory.a(FACTORY_PROPERTY, null);
                if (enumeration != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.c("[LOOKUP] Creating an instance of LogFactory class '" + (String)((Object)enumeration) + "' as specified by system property org.apache.commons.logging.LogFactory");
                    }
                    logFactory = LogFactory.newFactory((String)((Object)enumeration), classLoader, classLoader2);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.c("[LOOKUP] No system property [org.apache.commons.logging.LogFactory] defined.");
                }
            }
            catch (SecurityException securityException) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.c("[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.b(securityException.getMessage()) + "]. Trying alternative implementations...");
                }
            }
            catch (RuntimeException runtimeException) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.c("[LOOKUP] An exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.b(runtimeException.getMessage()) + "] as specified by a system property.");
                }
                throw runtimeException;
            }
            if (logFactory == null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.c("[LOOKUP] Looking for a resource file of name [META-INF/services/org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
                }
                try {
                    object = SERVICE_ID;
                    enumeration = classLoader2;
                    enumeration = (InputStream)AccessController.doPrivileged(new c((ClassLoader)((Object)enumeration), (String)object));
                    if (enumeration != null) {
                        try {
                            object = new BufferedReader(new InputStreamReader((InputStream)((Object)enumeration), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            object = new BufferedReader(new InputStreamReader((InputStream)((Object)enumeration)));
                        }
                        string = ((BufferedReader)object).readLine();
                        ((BufferedReader)object).close();
                        if (string != null && !"".equals(string)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.c("[LOOKUP]  Creating an instance of LogFactory class " + string + " as specified by file 'META-INF/services/org.apache.commons.logging.LogFactory" + "' which was present in the path of the context classloader.");
                            }
                            logFactory = LogFactory.newFactory(string, classLoader, classLoader2);
                        }
                        break block41;
                    }
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.c("[LOOKUP] No resource file with name 'META-INF/services/org.apache.commons.logging.LogFactory' found.");
                    }
                }
                catch (Exception exception) {
                    if (!LogFactory.isDiagnosticsEnabled()) break block41;
                    LogFactory.c("[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.b(exception.getMessage()) + "]. Trying alternative implementations...");
                }
            }
        }
        if (logFactory == null) {
            if (properties != null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.c("[LOOKUP] Looking in properties file for entry with key 'org.apache.commons.logging.LogFactory' to define the LogFactory subclass to use...");
                }
                if ((enumeration = properties.getProperty(FACTORY_PROPERTY)) != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.c("[LOOKUP] Properties file specifies LogFactory subclass '" + enumeration + "'");
                    }
                    logFactory = LogFactory.newFactory(enumeration, classLoader, classLoader2);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.c("[LOOKUP] Properties file has no entry specifying LogFactory subclass.");
                }
            } else if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.c("[LOOKUP] No properties file available to determine LogFactory subclass from..");
            }
        }
        if (logFactory == null) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.c("[LOOKUP] Loading the default LogFactory implementation 'org.apache.commons.logging.impl.LogFactoryImpl' via the same classloader that loaded this LogFactory class (ie not looking in the context classloader).");
            }
            logFactory = LogFactory.newFactory(FACTORY_DEFAULT, c, classLoader2);
        }
        if (logFactory != null) {
            object = logFactory;
            enumeration = classLoader2;
            if (object != null) {
                if (enumeration == null) {
                    nullClassLoaderFactory = object;
                } else {
                    factories.put(enumeration, object);
                }
            }
            if (properties != null) {
                enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    string = properties.getProperty((String)object);
                    logFactory.setAttribute((String)object, string);
                }
            }
        }
        return logFactory;
    }

    public static Log getLog(Class clazz) {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String string) {
        return LogFactory.getFactory().getInstance(string);
    }

    public static void release(ClassLoader classLoader) {
        Hashtable hashtable;
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.c("Releasing factory for classloader " + LogFactory.objectId(classLoader));
        }
        Hashtable hashtable2 = hashtable = factories;
        synchronized (hashtable) {
            if (classLoader == null) {
                if (nullClassLoaderFactory != null) {
                    nullClassLoaderFactory.release();
                    nullClassLoaderFactory = null;
                }
            } else {
                LogFactory logFactory = (LogFactory)hashtable.get(classLoader);
                if (logFactory != null) {
                    logFactory.release();
                    hashtable.remove(classLoader);
                }
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public static void releaseAll() {
        Hashtable hashtable;
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.c("Releasing factory for all classloaders.");
        }
        Hashtable hashtable2 = hashtable = factories;
        synchronized (hashtable) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                LogFactory logFactory = (LogFactory)enumeration.nextElement();
                logFactory.release();
            }
            hashtable.clear();
            if (nullClassLoaderFactory != null) {
                nullClassLoaderFactory.release();
                nullClassLoaderFactory = null;
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    protected static ClassLoader getClassLoader(Class clazz) {
        try {
            return clazz.getClassLoader();
        }
        catch (SecurityException securityException) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.c("Unable to get classloader for class '" + clazz + "' due to security restrictions - " + securityException.getMessage());
            }
            throw securityException;
        }
    }

    protected static ClassLoader getContextClassLoader() {
        return LogFactory.directGetContextClassLoader();
    }

    protected static ClassLoader directGetContextClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {}
        return classLoader;
    }

    protected static LogFactory newFactory(String object, ClassLoader classLoader, ClassLoader classLoader2) {
        if ((object = AccessController.doPrivileged(new b((String)object, classLoader))) instanceof LogConfigurationException) {
            object = (LogConfigurationException)object;
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.c("An error occurred while loading the factory class:" + ((Throwable)object).getMessage());
            }
            throw object;
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.c("Created object " + LogFactory.objectId(object) + " to manage classloader " + LogFactory.objectId(classLoader2));
        }
        return (LogFactory)object;
    }

    protected static LogFactory newFactory(String string, ClassLoader classLoader) {
        return LogFactory.newFactory(string, classLoader, null);
    }

    protected static Object createFactory(String string, ClassLoader classLoader) {
        Class<?> clazz = null;
        try {
            block21: {
                if (classLoader != null) {
                    try {
                        clazz = classLoader.loadClass(string);
                        if ((d == null ? (d = LogFactory.d(FACTORY_PROPERTY)) : d).isAssignableFrom(clazz)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.c("Loaded class " + clazz.getName() + " from classloader " + LogFactory.objectId(classLoader));
                            }
                        } else if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.c("Factory class " + clazz.getName() + " loaded from classloader " + LogFactory.objectId(clazz.getClassLoader()) + " does not extend '" + (d == null ? (d = LogFactory.d(FACTORY_PROPERTY)) : d).getName() + "' as loaded by this classloader.");
                            LogFactory.a("[BAD CL TREE] ", classLoader);
                        }
                        return (LogFactory)clazz.newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (classLoader == c) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.c("Unable to locate any class called '" + string + "' via classloader " + LogFactory.objectId(classLoader));
                            }
                            throw classNotFoundException;
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        if (classLoader == c) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.c("Class '" + string + "' cannot be loaded via classloader " + LogFactory.objectId(classLoader) + " - it depends on some other class that cannot be found.");
                            }
                            throw noClassDefFoundError;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        if (classLoader != c) break block21;
                        boolean bl2 = LogFactory.a(clazz);
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("The application has specified that a custom LogFactory implementation ");
                        stringBuffer.append("should be used but Class '");
                        stringBuffer.append(string);
                        stringBuffer.append("' cannot be converted to '");
                        stringBuffer.append((d == null ? (d = LogFactory.d(FACTORY_PROPERTY)) : d).getName());
                        stringBuffer.append("'. ");
                        if (bl2) {
                            stringBuffer.append("The conflict is caused by the presence of multiple LogFactory classes ");
                            stringBuffer.append("in incompatible classloaders. ");
                            stringBuffer.append("Background can be found in http://commons.apache.org/logging/tech.html. ");
                            stringBuffer.append("If you have not explicitly specified a custom LogFactory then it is likely ");
                            stringBuffer.append("that the container has set one without your knowledge. ");
                            stringBuffer.append("In this case, consider using the commons-logging-adapters.jar file or ");
                            stringBuffer.append("specifying the standard LogFactory from the command line. ");
                        } else {
                            stringBuffer.append("Please check the custom implementation. ");
                        }
                        stringBuffer.append("Help can be found @http://commons.apache.org/logging/troubleshooting.html.");
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.c(stringBuffer.toString());
                        }
                        throw new ClassCastException(stringBuffer.toString());
                    }
                }
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.c("Unable to load factory class via classloader " + LogFactory.objectId(classLoader) + " - trying the classloader associated with this LogFactory.");
            }
            clazz = Class.forName(string);
            return (LogFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.c("Unable to create LogFactory instance.");
            }
            if (clazz != null && !(d == null ? (d = LogFactory.d(FACTORY_PROPERTY)) : d).isAssignableFrom(clazz)) {
                return new LogConfigurationException("The chosen LogFactory implementation does not extend LogFactory. Please check your configuration.", exception);
            }
            return new LogConfigurationException(exception);
        }
    }

    private static boolean a(Class clazz) {
        boolean bl2 = false;
        if (clazz != null) {
            try {
                Object object = clazz.getClassLoader();
                if (object == null) {
                    LogFactory.c("[CUSTOM LOG FACTORY] was loaded by the boot classloader");
                } else {
                    LogFactory.a("[CUSTOM LOG FACTORY] ", (ClassLoader)object);
                    object = Class.forName(FACTORY_PROPERTY, false, (ClassLoader)object);
                    bl2 = ((Class)object).isAssignableFrom(clazz);
                    if (bl2) {
                        LogFactory.c("[CUSTOM LOG FACTORY] " + clazz.getName() + " implements LogFactory but was loaded by an incompatible classloader.");
                    } else {
                        LogFactory.c("[CUSTOM LOG FACTORY] " + clazz.getName() + " does not implement LogFactory.");
                    }
                }
            }
            catch (SecurityException securityException) {
                LogFactory.c("[CUSTOM LOG FACTORY] SecurityException thrown whilst trying to determine whether the compatibility was caused by a classloader conflict: " + securityException.getMessage());
            }
            catch (LinkageError linkageError) {
                LogFactory.c("[CUSTOM LOG FACTORY] LinkageError thrown whilst trying to determine whether the compatibility was caused by a classloader conflict: " + linkageError.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogFactory.c("[CUSTOM LOG FACTORY] LogFactory class cannot be loaded by classloader which loaded the custom LogFactory implementation. Is the custom factory in the right classloader?");
            }
        }
        return bl2;
    }

    private static final Properties a(ClassLoader object, String string) {
        URL uRL;
        Object object2;
        block12: {
            object2 = null;
            double d2 = 0.0;
            uRL = null;
            try {
                Object object3 = string;
                Object object4 = object;
                object = new d((ClassLoader)object4, (String)object3);
                object = AccessController.doPrivileged(object);
                object = (Enumeration)object;
                if (object == null) {
                    return null;
                }
                while (object.hasMoreElements()) {
                    URL uRL2 = (URL)object.nextElement();
                    object4 = uRL2;
                    object3 = new e((URL)object4);
                    if ((object4 = (Properties)AccessController.doPrivileged(object3)) == null) continue;
                    if (object2 == null) {
                        uRL = uRL2;
                        object2 = object4;
                        object3 = ((Properties)object2).getProperty(PRIORITY_KEY);
                        d2 = 0.0;
                        if (object3 != null) {
                            d2 = Double.parseDouble((String)object3);
                        }
                        if (!LogFactory.isDiagnosticsEnabled()) continue;
                        LogFactory.c("[LOOKUP] Properties file found at '" + uRL2 + "' with priority " + d2);
                        continue;
                    }
                    object3 = ((Properties)object4).getProperty(PRIORITY_KEY);
                    double d3 = 0.0;
                    if (object3 != null) {
                        d3 = Double.parseDouble((String)object3);
                    }
                    if (d3 > d2) {
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.c("[LOOKUP] Properties file at '" + uRL2 + "' with priority " + d3 + " overrides file at '" + uRL + "' with priority " + d2);
                        }
                        uRL = uRL2;
                        object2 = object4;
                        d2 = d3;
                        continue;
                    }
                    if (!LogFactory.isDiagnosticsEnabled()) continue;
                    LogFactory.c("[LOOKUP] Properties file at '" + uRL2 + "' with priority " + d3 + " does not override file at '" + uRL + "' with priority " + d2);
                }
            }
            catch (SecurityException securityException) {
                if (!LogFactory.isDiagnosticsEnabled()) break block12;
                LogFactory.c("SecurityException thrown while trying to find/read config files.");
            }
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            if (object2 == null) {
                LogFactory.c("[LOOKUP] No properties file of name '" + string + "' found.");
            } else {
                LogFactory.c("[LOOKUP] Properties file of name '" + string + "' found at '" + uRL + '\"');
            }
        }
        return object2;
    }

    private static String a(String string, String string2) {
        return (String)AccessController.doPrivileged(new f(string, null));
    }

    private static PrintStream b() {
        Object object;
        try {
            object = LogFactory.a(DIAGNOSTICS_DEST_PROPERTY, null);
            if (object == null) {
                return null;
            }
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (((String)object).equals("STDOUT")) {
            return System.out;
        }
        if (((String)object).equals("STDERR")) {
            return System.err;
        }
        try {
            object = new FileOutputStream((String)object, true);
            return new PrintStream((OutputStream)object);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static boolean isDiagnosticsEnabled() {
        return a != null;
    }

    private static final void c(String string) {
        if (a != null) {
            a.print(b);
            a.println(string);
            a.flush();
        }
    }

    protected static final void logRawDiagnostic(String string) {
        if (a != null) {
            a.println(string);
            a.flush();
        }
    }

    private static void a(String string, ClassLoader classLoader) {
        ClassLoader classLoader2;
        CharSequence charSequence;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        if (classLoader != null) {
            charSequence = classLoader.toString();
            LogFactory.c(string + LogFactory.objectId(classLoader) + " == '" + (String)charSequence + "'");
        }
        try {
            classLoader2 = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            LogFactory.c(string + "Security forbids determining the system classloader.");
            return;
        }
        if (classLoader != null) {
            block9: {
                charSequence = new StringBuffer(string + "ClassLoader tree:");
                do {
                    ((StringBuffer)charSequence).append(LogFactory.objectId(classLoader));
                    if (classLoader == classLoader2) {
                        ((StringBuffer)charSequence).append(" (SYSTEM) ");
                    }
                    try {
                        classLoader = classLoader.getParent();
                    }
                    catch (SecurityException securityException) {
                        ((StringBuffer)charSequence).append(" --> SECRET");
                        break block9;
                    }
                    ((StringBuffer)charSequence).append(" --> ");
                } while (classLoader != null);
                ((StringBuffer)charSequence).append("BOOT");
            }
            LogFactory.c(((StringBuffer)charSequence).toString());
        }
    }

    public static String objectId(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + "@" + System.identityHashCode(object);
    }

    private static Class d(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static void a(String string) {
        LogFactory.c(string);
    }

    static {
        block8: {
            Object object;
            a = null;
            factories = null;
            nullClassLoaderFactory = null;
            c = LogFactory.getClassLoader(d == null ? (d = LogFactory.d(FACTORY_PROPERTY)) : d);
            try {
                object = c;
                object = c == null ? "BOOTLOADER" : LogFactory.objectId(object);
            }
            catch (SecurityException securityException) {
                object = "UNKNOWN";
            }
            b = "[LogFactory from " + (String)object + "] ";
            a = LogFactory.b();
            Object object2 = object = d == null ? (d = LogFactory.d(FACTORY_PROPERTY)) : d;
            if (LogFactory.isDiagnosticsEnabled()) {
                try {
                    LogFactory.c("[ENV] Extension directories (java.ext.dir): " + System.getProperty("java.ext.dir"));
                    LogFactory.c("[ENV] Application classpath (java.class.path): " + System.getProperty("java.class.path"));
                }
                catch (SecurityException securityException) {
                    LogFactory.c("[ENV] Security setting prevent interrogation of system classpaths.");
                }
                String string = ((Class)object).getName();
                try {
                    object = LogFactory.getClassLoader((Class)object);
                }
                catch (SecurityException securityException) {
                    LogFactory.c("[ENV] Security forbids determining the classloader for " + string);
                    break block8;
                }
                LogFactory.c("[ENV] Class " + string + " was loaded via classloader " + LogFactory.objectId(object));
                LogFactory.a("[ENV] Ancestry of classloader which loaded " + string + " is ", (ClassLoader)object);
            }
        }
        factories = LogFactory.a();
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.c("BOOTSTRAP COMPLETED");
        }
    }
}

