/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.a;
import org.apache.commons.logging.impl.b;
import org.apache.commons.logging.impl.c;

public class LogFactoryImpl
extends LogFactory {
    private static final int a = 32;
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    protected static final String LOG_PROPERTY_OLD = "org.apache.commons.logging.log";
    public static final String ALLOW_FLAWED_CONTEXT_PROPERTY = "org.apache.commons.logging.Log.allowFlawedContext";
    public static final String ALLOW_FLAWED_DISCOVERY_PROPERTY = "org.apache.commons.logging.Log.allowFlawedDiscovery";
    public static final String ALLOW_FLAWED_HIERARCHY_PROPERTY = "org.apache.commons.logging.Log.allowFlawedHierarchy";
    private static final String[] b = new String[]{"org.apache.commons.logging.impl.Log4JLogger", "org.apache.commons.logging.impl.Jdk14Logger", "org.apache.commons.logging.impl.Jdk13LumberjackLogger", "org.apache.commons.logging.impl.SimpleLog"};
    private boolean c = true;
    private String d;
    protected Hashtable attributes = new Hashtable();
    protected Hashtable instances = new Hashtable();
    private String e;
    protected Constructor logConstructor = null;
    protected Class[] logConstructorSignature = new Class[]{i == null ? (i = LogFactoryImpl.d("java.lang.String")) : i};
    protected Method logMethod = null;
    protected Class[] logMethodSignature = new Class[]{j == null ? (j = LogFactoryImpl.d("org.apache.commons.logging.LogFactory")) : j};
    private boolean f;
    private boolean g;
    private boolean h;
    private static Class i;
    private static Class j;
    private static Class k;
    private static Class l;

    public LogFactoryImpl() {
        LogFactoryImpl logFactoryImpl = this;
        Object object = logFactoryImpl.getClass();
        object = LogFactoryImpl.getClassLoader(object);
        try {
            object = object == null ? "BOOTLOADER" : LogFactoryImpl.objectId(object);
        }
        catch (SecurityException securityException) {
            object = "UNKNOWN";
        }
        logFactoryImpl.d = "[LogFactoryImpl@" + System.identityHashCode(logFactoryImpl) + " from " + (String)object + "] ";
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Instance created.");
        }
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public Log getInstance(Class clazz) {
        return ((LogFactory)this).getInstance(clazz.getName());
    }

    public Log getInstance(String string) {
        Log log = (Log)this.instances.get(string);
        if (log == null) {
            log = this.newInstance(string);
            this.instances.put(string, log);
        }
        return log;
    }

    public void release() {
        this.logDiagnostic("Releasing all known loggers");
        this.instances.clear();
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (this.logConstructor != null) {
            this.logDiagnostic("setAttribute: call too late; configuration already performed.");
        }
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
        if (string.equals("use_tccl")) {
            this.c = object != null && Boolean.valueOf(object.toString()) != false;
        }
    }

    protected static ClassLoader getContextClassLoader() {
        return LogFactory.getContextClassLoader();
    }

    protected static boolean isDiagnosticsEnabled() {
        return LogFactory.isDiagnosticsEnabled();
    }

    protected static ClassLoader getClassLoader(Class clazz) {
        return LogFactory.getClassLoader(clazz);
    }

    protected void logDiagnostic(String string) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            LogFactoryImpl.logRawDiagnostic(this.d + string);
        }
    }

    protected String getLogClassName() {
        if (this.e == null) {
            LogFactoryImpl logFactoryImpl = this;
            logFactoryImpl.c(logFactoryImpl.getClass().getName());
        }
        return this.e;
    }

    protected Constructor getLogConstructor() {
        if (this.logConstructor == null) {
            LogFactoryImpl logFactoryImpl = this;
            logFactoryImpl.c(logFactoryImpl.getClass().getName());
        }
        return this.logConstructor;
    }

    protected boolean isJdk13LumberjackAvailable() {
        return this.b("Jdk13Lumberjack", "org.apache.commons.logging.impl.Jdk13LumberjackLogger");
    }

    protected boolean isJdk14Available() {
        return this.b("Jdk14", "org.apache.commons.logging.impl.Jdk14Logger");
    }

    protected boolean isLog4JAvailable() {
        return this.b("Log4J", "org.apache.commons.logging.impl.Log4JLogger");
    }

    protected Log newInstance(String object) {
        try {
            Object[] objectArray;
            if (this.logConstructor == null) {
                object = this.c((String)object);
            } else {
                objectArray = new Object[]{object};
                object = (Log)this.logConstructor.newInstance(objectArray);
            }
            if (this.logMethod != null) {
                objectArray = new Object[]{this};
                this.logMethod.invoke(object, objectArray);
            }
            return object;
        }
        catch (LogConfigurationException logConfigurationException) {
            LogConfigurationException logConfigurationException2 = logConfigurationException;
            throw logConfigurationException;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            object = invocationTargetException.getTargetException();
            throw new LogConfigurationException((Throwable)(object == null ? invocationTargetException2 : object));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            LogFactoryImpl.handleThrowable(throwable);
            throw new LogConfigurationException(throwable2);
        }
    }

    private static String a(String string, String string2) {
        return (String)AccessController.doPrivileged(new b(string, null));
    }

    private ClassLoader a(ClassLoader classLoader) {
        try {
            return (ClassLoader)AccessController.doPrivileged(new c(this, classLoader));
        }
        catch (SecurityException securityException) {
            this.logDiagnostic("[SECURITY] Unable to obtain parent classloader");
            return null;
        }
    }

    private boolean b(String string, String object) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Checking for '" + string + "'.");
        }
        try {
            object = this.a((String)object, this.getClass().getName(), false);
            if (object == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Did not find '" + string + "'.");
                }
                return false;
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Found '" + string + "'.");
            }
            return true;
        }
        catch (LogConfigurationException logConfigurationException) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Logging system '" + string + "' is available but not useable.");
            }
            return false;
        }
    }

    private String b(String string) {
        block10: {
            Object object;
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[ENV] Trying to get configuration for item " + string);
            }
            if ((object = ((LogFactory)this).getAttribute(string)) != null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[ENV] Found LogFactory attribute [" + object + "] for " + string);
                }
                return object.toString();
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[ENV] No LogFactory attribute found for " + string);
            }
            try {
                object = LogFactoryImpl.a(string, null);
                if (object != null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("[ENV] Found system property [" + (String)object + "] for " + string);
                    }
                    return object;
                }
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[ENV] No system property found for property " + string);
                }
            }
            catch (SecurityException securityException) {
                if (!LogFactoryImpl.isDiagnosticsEnabled()) break block10;
                this.logDiagnostic("[ENV] Security prevented reading system property " + string);
            }
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("[ENV] No configuration defined for item " + string);
        }
        return null;
    }

    private boolean a(String string, boolean bl2) {
        if ((string = this.b(string)) == null) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    private void b() {
        this.f = this.a(ALLOW_FLAWED_CONTEXT_PROPERTY, true);
        this.g = this.a(ALLOW_FLAWED_DISCOVERY_PROPERTY, true);
        this.h = this.a(ALLOW_FLAWED_HIERARCHY_PROPERTY, true);
    }

    private Log c(String string) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Discovering a Log implementation...");
        }
        this.b();
        Log log = null;
        String string2 = this.c();
        if (string2 != null) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Attempting to load user-specified log class '" + string2 + "'...");
            }
            if ((log = this.a(string2, string, true)) == null) {
                StringBuffer stringBuffer = new StringBuffer("User-specified log class '");
                stringBuffer.append(string2);
                stringBuffer.append("' cannot be found or is not useable.");
                LogFactoryImpl.a(stringBuffer, string2, "org.apache.commons.logging.impl.Log4JLogger");
                LogFactoryImpl.a(stringBuffer, string2, "org.apache.commons.logging.impl.Jdk14Logger");
                LogFactoryImpl.a(stringBuffer, string2, "org.apache.commons.logging.impl.Jdk13LumberjackLogger");
                LogFactoryImpl.a(stringBuffer, string2, "org.apache.commons.logging.impl.SimpleLog");
                throw new LogConfigurationException(stringBuffer.toString());
            }
            return log;
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("No user-specified Log implementation; performing discovery using the standard supported logging implementations...");
        }
        for (int i2 = 0; i2 < b.length && log == null; ++i2) {
            log = this.a(b[i2], string, true);
        }
        if (log == null) {
            throw new LogConfigurationException("No suitable Log implementation");
        }
        return log;
    }

    private static void a(StringBuffer stringBuffer, String string, String string2) {
        if (string.equals(string2)) {
            return;
        }
        if (string.regionMatches(true, 0, string2, 0, a + 5)) {
            stringBuffer.append(" Did you mean '");
            stringBuffer.append(string2);
            stringBuffer.append("'?");
        }
    }

    private String c() {
        String string;
        block13: {
            block12: {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Trying to get log class from attribute 'org.apache.commons.logging.Log'");
                }
                if ((string = (String)((LogFactory)this).getAttribute(LOG_PROPERTY)) == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("Trying to get log class from attribute 'org.apache.commons.logging.log'");
                    }
                    string = (String)((LogFactory)this).getAttribute(LOG_PROPERTY_OLD);
                }
                if (string == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("Trying to get log class from system property 'org.apache.commons.logging.Log'");
                    }
                    try {
                        string = LogFactoryImpl.a(LOG_PROPERTY, null);
                    }
                    catch (SecurityException securityException) {
                        if (!LogFactoryImpl.isDiagnosticsEnabled()) break block12;
                        this.logDiagnostic("No access allowed to system property 'org.apache.commons.logging.Log' - " + securityException.getMessage());
                    }
                }
            }
            if (string == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Trying to get log class from system property 'org.apache.commons.logging.log'");
                }
                try {
                    string = LogFactoryImpl.a(LOG_PROPERTY_OLD, null);
                }
                catch (SecurityException securityException) {
                    if (!LogFactoryImpl.isDiagnosticsEnabled()) break block13;
                    this.logDiagnostic("No access allowed to system property 'org.apache.commons.logging.log' - " + securityException.getMessage());
                }
            }
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Log a(String string, String objectArray, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ClassLoader classLoader;
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Attempting to instantiate '" + string + "'");
        }
        objectArray = new Object[]{objectArray};
        Log log = null;
        Constructor constructor = null;
        Class<?> clazz = null;
        Object object6 = this;
        Object object7 = LogFactoryImpl.getClassLoader(k == null ? (k = LogFactoryImpl.d("org.apache.commons.logging.impl.LogFactoryImpl")) : k);
        if (!((LogFactoryImpl)object6).c) {
            classLoader = object7;
        } else {
            Object object8;
            block44: {
                object5 = (Class<?>[])AccessController.doPrivileged(new a());
                object4 = object7;
                object3 = object5;
                object2 = object6;
                if (object3 == null) {
                    object8 = object4;
                } else if (object4 == null) {
                    object8 = object3;
                } else {
                    object7 = object3;
                    while (object7 != null) {
                        if (object7 == object4) {
                            object8 = object3;
                            break block44;
                        }
                        object7 = ((LogFactoryImpl)object2).a((ClassLoader)object7);
                    }
                    object7 = object4;
                    while (object7 != null) {
                        if (object7 == object3) {
                            object8 = object4;
                            break block44;
                        }
                        object7 = ((LogFactoryImpl)object2).a((ClassLoader)object7);
                    }
                    object8 = object = null;
                }
            }
            if (object8 == null) {
                if (!((LogFactoryImpl)object6).f) throw new LogConfigurationException("Bad classloader hierarchy; LogFactoryImpl was loaded via a classloader that is not related to the current context classloader.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    ((LogFactoryImpl)object6).logDiagnostic("[WARNING] the context classloader is not part of a parent-child relationship with the classloader that loaded LogFactoryImpl.");
                }
                classLoader = object5;
            } else {
                if (object != object5) {
                    if (!((LogFactoryImpl)object6).f) throw new LogConfigurationException("Bad classloader hierarchy; LogFactoryImpl was loaded via a classloader that is not related to the current context classloader.");
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        ((LogFactoryImpl)object6).logDiagnostic("Warning: the context classloader is an ancestor of the classloader that loaded LogFactoryImpl; it should be the same or a descendant. The application using commons-logging should ensure the context classloader is used correctly.");
                    }
                }
                classLoader = object;
            }
        }
        ClassLoader classLoader2 = classLoader;
        while (true) {
            block45: {
                this.logDiagnostic("Trying to load '" + string + "' from classloader " + LogFactoryImpl.objectId(classLoader2));
                try {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        object7 = string.replace('.', '/') + ".class";
                        object6 = classLoader2 != null ? classLoader2.getResource((String)object7) : ClassLoader.getSystemResource((String)object7 + ".class");
                        if (object6 == null) {
                            this.logDiagnostic("Class '" + string + "' [" + (String)object7 + "] cannot be found.");
                        } else {
                            this.logDiagnostic("Class '" + string + "' was found at '" + object6 + "'");
                        }
                    }
                    try {
                        object6 = Class.forName(string, true, classLoader2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        object7 = classNotFoundException;
                        object6 = classNotFoundException.getMessage();
                        this.logDiagnostic("The log adapter '" + string + "' is not available via classloader " + LogFactoryImpl.objectId(classLoader2) + ": " + ((String)object6).trim());
                        try {
                            object6 = Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            object6 = classNotFoundException2;
                            object6 = classNotFoundException2.getMessage();
                            this.logDiagnostic("The log adapter '" + string + "' is not available via the LogFactoryImpl class classloader: " + ((String)object6).trim());
                            break;
                        }
                    }
                    constructor = ((Class)object6).getConstructor(this.logConstructorSignature);
                    object7 = constructor.newInstance(objectArray);
                    if (object7 instanceof Log) {
                        clazz = object6;
                        log = (Log)object7;
                        break;
                    }
                    object5 = object6;
                    object7 = classLoader2;
                    object6 = this;
                    boolean bl3 = false;
                    object2 = (l == null ? LogFactoryImpl.d(LOG_PROPERTY) : l).getName();
                    object3 = ((Class)object5).getInterfaces();
                    for (int i2 = 0; i2 < ((Class<?>[])object3).length; ++i2) {
                        if (!((String)object2).equals(object3[i2].getName())) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) {
                        if (LogFactoryImpl.isDiagnosticsEnabled()) {
                            try {
                                ClassLoader classLoader3 = LogFactoryImpl.getClassLoader(l == null ? LogFactoryImpl.d(LOG_PROPERTY) : l);
                                ((LogFactoryImpl)object6).logDiagnostic("Class '" + ((Class)object5).getName() + "' was found in classloader " + LogFactoryImpl.objectId(object7) + ". It is bound to a Log interface which is not the one loaded from classloader " + LogFactoryImpl.objectId(classLoader3));
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                LogFactoryImpl.handleThrowable(throwable);
                                ((LogFactoryImpl)object6).logDiagnostic("Error while trying to output diagnostics about bad class '" + object5 + "'");
                            }
                        }
                        if (!((LogFactoryImpl)object6).h) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("Terminating logging for this context ");
                            stringBuffer.append("due to bad log hierarchy. ");
                            stringBuffer.append("You have more than one version of '");
                            stringBuffer.append((l == null ? (l = LogFactoryImpl.d(LOG_PROPERTY)) : l).getName());
                            stringBuffer.append("' visible.");
                            if (!LogFactoryImpl.isDiagnosticsEnabled()) throw new LogConfigurationException(stringBuffer.toString());
                            ((LogFactoryImpl)object6).logDiagnostic(stringBuffer.toString());
                            throw new LogConfigurationException(stringBuffer.toString());
                        }
                        if (LogFactoryImpl.isDiagnosticsEnabled()) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("Warning: bad log hierarchy. ");
                            stringBuffer.append("You have more than one version of '");
                            stringBuffer.append((l == null ? LogFactoryImpl.d(LOG_PROPERTY) : l).getName());
                            stringBuffer.append("' visible.");
                            ((LogFactoryImpl)object6).logDiagnostic(stringBuffer.toString());
                        }
                        break block45;
                    }
                    if (!((LogFactoryImpl)object6).g) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Terminating logging for this context. ");
                        stringBuffer.append("Log class '");
                        stringBuffer.append(((Class)object5).getName());
                        stringBuffer.append("' does not implement the Log interface.");
                        if (!LogFactoryImpl.isDiagnosticsEnabled()) throw new LogConfigurationException(stringBuffer.toString());
                        ((LogFactoryImpl)object6).logDiagnostic(stringBuffer.toString());
                        throw new LogConfigurationException(stringBuffer.toString());
                    }
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("[WARNING] Log class '");
                        stringBuffer.append(((Class)object5).getName());
                        stringBuffer.append("' does not implement the Log interface.");
                        ((LogFactoryImpl)object6).logDiagnostic(stringBuffer.toString());
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    object6 = noClassDefFoundError;
                    object7 = noClassDefFoundError.getMessage();
                    this.logDiagnostic("The log adapter '" + string + "' is missing dependencies when loaded via classloader " + LogFactoryImpl.objectId(classLoader2) + ": " + ((String)object7).trim());
                    break;
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    object6 = exceptionInInitializerError;
                    object7 = exceptionInInitializerError.getMessage();
                    this.logDiagnostic("The log adapter '" + string + "' is unable to initialize itself when loaded via classloader " + LogFactoryImpl.objectId(classLoader2) + ": " + ((String)object7).trim());
                    break;
                }
                catch (LogConfigurationException logConfigurationException) {
                    object6 = logConfigurationException;
                    throw logConfigurationException;
                }
                catch (Throwable throwable) {
                    object6 = throwable;
                    LogFactoryImpl.handleThrowable(throwable);
                    object5 = object6;
                    object7 = string;
                    object6 = this;
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        ((LogFactoryImpl)object6).logDiagnostic("Could not instantiate Log '" + (String)object7 + "' -- " + object5.getClass().getName() + ": " + ((Throwable)object5).getLocalizedMessage());
                        if (object5 instanceof InvocationTargetException && (object3 = ((InvocationTargetException)(object2 = (InvocationTargetException)object5)).getTargetException()) != null) {
                            ((LogFactoryImpl)object6).logDiagnostic("... InvocationTargetException: " + object3.getClass().getName() + ": " + ((Throwable)object3).getLocalizedMessage());
                            if (object3 instanceof ExceptionInInitializerError && (object7 = ((ExceptionInInitializerError)(object4 = (ExceptionInInitializerError)object3)).getException()) != null) {
                                object = new StringWriter();
                                ((Throwable)object7).printStackTrace(new PrintWriter((Writer)object, true));
                                ((LogFactoryImpl)object6).logDiagnostic("... ExceptionInInitializerError: " + ((StringWriter)object).toString());
                            }
                        }
                    }
                    if (((LogFactoryImpl)object6).g) break block45;
                    throw new LogConfigurationException((Throwable)object5);
                }
            }
            if (classLoader2 == null) break;
            classLoader2 = this.a(classLoader2);
        }
        if (clazz == null || !bl2) return log;
        this.e = string;
        this.logConstructor = constructor;
        try {
            this.logMethod = clazz.getMethod("setLogFactory", this.logMethodSignature);
            this.logDiagnostic("Found method setLogFactory(LogFactory) in '" + string + "'");
        }
        catch (Throwable throwable) {
            object6 = throwable;
            LogFactoryImpl.handleThrowable(throwable);
            this.logMethod = null;
            this.logDiagnostic("[INFO] '" + string + "' from classloader " + LogFactoryImpl.objectId(classLoader2) + " does not declare optional method setLogFactory(LogFactory)");
        }
        this.logDiagnostic("Log adapter '" + string + "' from classloader " + LogFactoryImpl.objectId(clazz.getClassLoader()) + " has been selected for use.");
        return log;
    }

    private static Class d(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static ClassLoader a() {
        return LogFactoryImpl.directGetContextClassLoader();
    }
}

