/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.impl.d;

public class SimpleLog
implements Serializable,
Log {
    protected static final String systemPrefix = "org.apache.commons.logging.simplelog.";
    protected static final Properties simpleLogProps = new Properties();
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static volatile boolean showLogName = false;
    protected static volatile boolean showShortName = true;
    protected static volatile boolean showDateTime = false;
    protected static volatile String dateTimeFormat = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static DateFormat dateFormatter = null;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected volatile String logName = null;
    protected volatile int currentLogLevel;
    private volatile String a = null;
    private static Class b;
    private static Class c;

    private static String a(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {}
        if (string2 == null) {
            return simpleLogProps.getProperty(string);
        }
        return string2;
    }

    private static boolean a(String string, boolean bl2) {
        if ((string = SimpleLog.a(string)) == null) {
            return bl2;
        }
        return "true".equalsIgnoreCase(string);
    }

    public SimpleLog(String string) {
        this.logName = string;
        this.setLevel(3);
        String string2 = SimpleLog.a("org.apache.commons.logging.simplelog.log." + this.logName);
        int n2 = String.valueOf(string).lastIndexOf(".");
        while (string2 == null && n2 >= 0) {
            string = string.substring(0, n2);
            string2 = SimpleLog.a("org.apache.commons.logging.simplelog.log." + string);
            n2 = String.valueOf(string).lastIndexOf(".");
        }
        if (string2 == null) {
            string2 = SimpleLog.a("org.apache.commons.logging.simplelog.defaultlog");
        }
        if ("all".equalsIgnoreCase(string2)) {
            this.setLevel(0);
            return;
        }
        if ("trace".equalsIgnoreCase(string2)) {
            this.setLevel(1);
            return;
        }
        if ("debug".equalsIgnoreCase(string2)) {
            this.setLevel(2);
            return;
        }
        if ("info".equalsIgnoreCase(string2)) {
            this.setLevel(3);
            return;
        }
        if ("warn".equalsIgnoreCase(string2)) {
            this.setLevel(4);
            return;
        }
        if ("error".equalsIgnoreCase(string2)) {
            this.setLevel(5);
            return;
        }
        if ("fatal".equalsIgnoreCase(string2)) {
            this.setLevel(6);
            return;
        }
        if ("off".equalsIgnoreCase(string2)) {
            this.setLevel(7);
        }
    }

    public void setLevel(int n2) {
        this.currentLogLevel = n2;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    protected void log(int n2, Object object, Throwable throwable) {
        Object object2;
        Object object3;
        StringBuffer stringBuffer = new StringBuffer();
        if (showDateTime) {
            object3 = new Date();
            DateFormat dateFormat = dateFormatter;
            synchronized (dateFormat) {
                object2 = dateFormatter.format((Date)object3);
            }
            stringBuffer.append((String)object2);
            stringBuffer.append(" ");
        }
        switch (n2) {
            case 1: {
                stringBuffer.append("[TRACE] ");
                break;
            }
            case 2: {
                stringBuffer.append("[DEBUG] ");
                break;
            }
            case 3: {
                stringBuffer.append("[INFO] ");
                break;
            }
            case 4: {
                stringBuffer.append("[WARN] ");
                break;
            }
            case 5: {
                stringBuffer.append("[ERROR] ");
                break;
            }
            case 6: {
                stringBuffer.append("[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.a == null) {
                Object object4 = object3 = this.logName.substring(this.logName.lastIndexOf(".") + 1);
                this.a = ((String)object4).substring(((String)object4).lastIndexOf("/") + 1);
            }
            stringBuffer.append(String.valueOf(this.a)).append(" - ");
        } else if (showLogName) {
            stringBuffer.append(String.valueOf(this.logName)).append(" - ");
        }
        stringBuffer.append(String.valueOf(object));
        if (throwable != null) {
            stringBuffer.append(" <");
            stringBuffer.append(throwable.toString());
            stringBuffer.append(">");
            object3 = new StringWriter(1024);
            object2 = new PrintWriter((Writer)object3);
            throwable.printStackTrace((PrintWriter)object2);
            ((PrintWriter)object2).close();
            stringBuffer.append(((StringWriter)object3).toString());
        }
        this.write(stringBuffer);
    }

    protected void write(StringBuffer stringBuffer) {
        System.err.println(stringBuffer.toString());
    }

    protected boolean isLevelEnabled(int n2) {
        return n2 >= this.currentLogLevel;
    }

    public final void debug(Object object) {
        if (this.isLevelEnabled(2)) {
            this.log(2, object, null);
        }
    }

    public final void debug(Object object, Throwable throwable) {
        if (this.isLevelEnabled(2)) {
            this.log(2, object, throwable);
        }
    }

    public final void trace(Object object) {
        if (this.isLevelEnabled(1)) {
            this.log(1, object, null);
        }
    }

    public final void trace(Object object, Throwable throwable) {
        if (this.isLevelEnabled(1)) {
            this.log(1, object, throwable);
        }
    }

    public final void info(Object object) {
        if (this.isLevelEnabled(3)) {
            this.log(3, object, null);
        }
    }

    public final void info(Object object, Throwable throwable) {
        if (this.isLevelEnabled(3)) {
            this.log(3, object, throwable);
        }
    }

    public final void warn(Object object) {
        if (this.isLevelEnabled(4)) {
            this.log(4, object, null);
        }
    }

    public final void warn(Object object, Throwable throwable) {
        if (this.isLevelEnabled(4)) {
            this.log(4, object, throwable);
        }
    }

    public final void error(Object object) {
        if (this.isLevelEnabled(5)) {
            this.log(5, object, null);
        }
    }

    public final void error(Object object, Throwable throwable) {
        if (this.isLevelEnabled(5)) {
            this.log(5, object, throwable);
        }
    }

    public final void fatal(Object object) {
        if (this.isLevelEnabled(6)) {
            this.log(6, object, null);
        }
    }

    public final void fatal(Object object, Throwable throwable) {
        if (this.isLevelEnabled(6)) {
            this.log(6, object, throwable);
        }
    }

    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    private static ClassLoader b() {
        ClassLoader classLoader = null;
        try {
            Object object = (b == null ? (b = SimpleLog.b("java.lang.Thread")) : b).getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)((Method)object).invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException;
                if (!(invocationTargetException.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException("Unexpected InvocationTargetException", ((InvocationTargetException)object).getTargetException());
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (classLoader == null) {
            classLoader = (c == null ? (c = SimpleLog.b("org.apache.commons.logging.impl.SimpleLog")) : c).getClassLoader();
        }
        return classLoader;
    }

    private static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static ClassLoader a() {
        return SimpleLog.b();
    }

    static {
        Object object = "simplelog.properties";
        if ((object = (InputStream)AccessController.doPrivileged(new d((String)object))) != null) {
            try {
                simpleLogProps.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
        }
        showLogName = SimpleLog.a("org.apache.commons.logging.simplelog.showlogname", showLogName);
        showShortName = SimpleLog.a("org.apache.commons.logging.simplelog.showShortLogname", showShortName);
        if (showDateTime = SimpleLog.a("org.apache.commons.logging.simplelog.showdatetime", showDateTime)) {
            String string = dateTimeFormat;
            object = "org.apache.commons.logging.simplelog.dateTimeFormat";
            object = SimpleLog.a("org.apache.commons.logging.simplelog.dateTimeFormat");
            dateTimeFormat = object == null ? string : object;
            try {
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                dateTimeFormat = DEFAULT_DATE_TIME_FORMAT;
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
        }
    }
}

