/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.event.LoggingEvent;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.NOP_FallbackServiceProvider;
import org.slf4j.helpers.SubstituteLogger;
import org.slf4j.helpers.SubstituteServiceProvider;
import org.slf4j.helpers.Util;
import org.slf4j.spi.SLF4JServiceProvider;

public final class LoggerFactory {
    public static final String PROVIDER_PROPERTY_KEY = "slf4j.provider";
    private static volatile int b = 0;
    private static SubstituteServiceProvider c = new SubstituteServiceProvider();
    private static NOP_FallbackServiceProvider d = new NOP_FallbackServiceProvider();
    static boolean a = Util.safeGetBooleanSystemProperty("slf4j.detectLoggerNameMismatch");
    private static volatile SLF4JServiceProvider e;
    private static final String[] f;

    private static List<SLF4JServiceProvider> c() {
        ArrayList<SLF4JServiceProvider> arrayList = new ArrayList<SLF4JServiceProvider>();
        Object object = LoggerFactory.class.getClassLoader();
        Object object2 = LoggerFactory.a((ClassLoader)object);
        if (object2 != null) {
            arrayList.add((SLF4JServiceProvider)object2);
            return arrayList;
        }
        object2 = object;
        Object object3 = System.getSecurityManager();
        if (object3 == null) {
            object3 = ServiceLoader.load(SLF4JServiceProvider.class, (ClassLoader)object2);
        } else {
            object = () -> LoggerFactory.b((ClassLoader)object2);
            object3 = AccessController.doPrivileged(object);
        }
        object = object3;
        object = ((ServiceLoader)object).iterator();
        while (object.hasNext()) {
            object3 = object;
            object2 = arrayList;
            try {
                object3 = (SLF4JServiceProvider)object3.next();
                object2.add((SLF4JServiceProvider)object3);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                Util.report("A SLF4J service provider failed to instantiate:\n" + serviceConfigurationError.getMessage());
            }
        }
        return arrayList;
    }

    private LoggerFactory() {
    }

    static void a() {
        b = 0;
    }

    private static SLF4JServiceProvider a(ClassLoader genericDeclaration) {
        String string = System.getProperty(PROVIDER_PROPERTY_KEY);
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            String string2 = String.format("Attempting to load provider \"%s\" specified via \"%s\" system property", string, PROVIDER_PROPERTY_KEY);
            Util.report(string2);
            genericDeclaration = ((ClassLoader)((Object)genericDeclaration)).loadClass(string);
            genericDeclaration = genericDeclaration.getConstructor(new Class[0]);
            genericDeclaration = ((Constructor)genericDeclaration).newInstance(new Object[0]);
            return (SLF4JServiceProvider)((Object)genericDeclaration);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            genericDeclaration = String.format("Failed to instantiate the specified SLF4JServiceProvider (%s)", string);
            Util.report((String)((Object)genericDeclaration), reflectiveOperationException);
            return null;
        }
        catch (ClassCastException classCastException) {
            genericDeclaration = String.format("Specified SLF4JServiceProvider (%s) does not implement SLF4JServiceProvider interface", string);
            Util.report((String)((Object)genericDeclaration), classCastException);
            return null;
        }
    }

    private static Set<URL> d() {
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> enumeration = LoggerFactory.class.getClassLoader();
            enumeration = enumeration == null ? ClassLoader.getSystemResources("org/slf4j/impl/StaticLoggerBinder.class") : ((ClassLoader)((Object)enumeration)).getResources("org/slf4j/impl/StaticLoggerBinder.class");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                linkedHashSet.add(uRL);
            }
        }
        catch (IOException iOException) {
            Util.report("Error getting resources from path", iOException);
        }
        return linkedHashSet;
    }

    private static void e() {
        SubstituteServiceProvider substituteServiceProvider = c;
        synchronized (substituteServiceProvider) {
            c.getSubstituteLoggerFactory().postInitialization();
            for (SubstituteLogger substituteLogger : c.getSubstituteLoggerFactory().getLoggers()) {
                Logger logger = LoggerFactory.getLogger(substituteLogger.getName());
                substituteLogger.setDelegate(logger);
            }
            return;
        }
    }

    private static boolean a(List<SLF4JServiceProvider> list) {
        return list.size() > 1;
    }

    public static Logger getLogger(String string) {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        return iLoggerFactory.getLogger(string);
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> clazz2;
        Class<?> clazz3;
        Logger logger = LoggerFactory.getLogger(clazz.getName());
        if (a && (clazz3 = Util.getCallingClass()) != null && !(clazz2 = clazz3).isAssignableFrom(clazz)) {
            Util.report(String.format("Detected logger name mismatch. Given name: \"%s\"; computed name: \"%s\".", logger.getName(), clazz3.getName()));
            Util.report("See https://www.slf4j.org/codes.html#loggerNameMismatch for an explanation");
        }
        return logger;
    }

    public static ILoggerFactory getILoggerFactory() {
        return LoggerFactory.b().getLoggerFactory();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static SLF4JServiceProvider b() {
        if (LoggerFactory.b != 0) ** GOTO lbl65
        var0 = LoggerFactory.class;
        synchronized (LoggerFactory.class) {
            if (LoggerFactory.b != 0) ** GOTO lbl64
            LoggerFactory.b = 1;
            try {
                var1_1 = LoggerFactory.c();
                var3_4 = var1_1;
                if (LoggerFactory.a(var1_1)) {
                    Util.report("Class path contains multiple SLF4J providers.");
                    for (Object var5_8 : var3_4) {
                        Util.report("Found provider [" + var5_8 + "]");
                    }
                    Util.report("See https://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
                }
                if (!var1_1.isEmpty()) {
                    LoggerFactory.e = var1_1.get(0);
                    LoggerFactory.e.initialize();
                    LoggerFactory.b = 3;
                    var3_4 = var1_1;
                    if (!var3_4.isEmpty() && LoggerFactory.a(var3_4)) {
                        Util.report("Actual provider is of type [" + var3_4.get(0) + "]");
                    }
                } else {
                    LoggerFactory.b = 4;
                    Util.report("No SLF4J providers were found.");
                    Util.report("Defaulting to no-operation (NOP) logger implementation");
                    Util.report("See https://www.slf4j.org/codes.html#noProviders for further details.");
                    var2_10 = LoggerFactory.d();
                    var3_4 = var2_10;
                    if (!var2_10.isEmpty()) {
                        Util.report("Class path contains SLF4J bindings targeting slf4j-api versions 1.7.x or earlier.");
                        for (Object var5_8 : var3_4) {
                            Util.report("Ignoring binding found at [" + var5_8 + "]");
                        }
                        Util.report("See https://www.slf4j.org/codes.html#ignoredBindings for an explanation.");
                    }
                }
                LoggerFactory.e();
                var3_4 = LoggerFactory.c.getSubstituteLoggerFactory().getEventQueue();
                var4_7 = var3_4.size();
                var5_9 = 0;
                var1_1 = new ArrayList<SLF4JServiceProvider>(128);
                while (true) {
                    if ((var2_11 = var3_4.drainTo((Collection<Object>)var1_1, 128)) != 0) {
                        var2_10 = var1_1.iterator();
                    } else {
                        LoggerFactory.c.getSubstituteLoggerFactory().clear();
                        if (LoggerFactory.b == 3) {
                            try {
                                var1_1 = LoggerFactory.e.getRequestedApiVersion();
                                var2_11 = 0;
                                var3_4 = LoggerFactory.f;
                                var4_7 = LoggerFactory.f.length;
                                for (var5_9 = 0; var5_9 < var4_7; ++var5_9) {
                                    var6_12 = var3_4[var5_9];
                                    if (!var1_1.startsWith((String)var6_12)) continue;
                                    var2_11 = 1;
                                }
                                if (var2_11 == 0) {
                                    Util.report("The requested version " + (String)var1_1 + " by your slf4j provider is not compatible with " + Arrays.asList(LoggerFactory.f).toString());
                                    Util.report("See https://www.slf4j.org/codes.html#version_mismatch for further details.");
                                }
                            }
                            catch (NoSuchFieldError v0) {
                            }
                            catch (Throwable var1_3) {
                                Util.report("Unexpected problem occurred during version sanity check", var1_3);
                            }
                        }
lbl64:
                        // 6 sources

                        // ** MonitorExit[var0] (shouldn't be in output)
lbl65:
                        // 2 sources

                        switch (LoggerFactory.b) {
                            case 3: {
                                return LoggerFactory.e;
                            }
                            case 4: {
                                return LoggerFactory.d;
                            }
                            case 2: {
                                throw new IllegalStateException("org.slf4j.LoggerFactory in failed state. Original exception was thrown EARLIER. See also https://www.slf4j.org/codes.html#unsuccessfulInit");
                            }
                            case 1: {
                                return LoggerFactory.c;
                            }
                        }
                        throw new IllegalStateException("Unreachable code");
                    }
                    while (var2_10.hasNext()) {
                        var6_12 = (SubstituteLoggingEvent)var2_10.next();
                        var7_13 = var6_12;
                        if (var6_12 != null) {
                            var8_14 = var7_13.getLogger();
                            var9_16 = var8_14.getName();
                            if (var8_14.isDelegateNull()) {
                                throw new IllegalStateException("Delegate logger cannot be null at this state.");
                            }
                            if (!var8_14.isDelegateNOP()) {
                                if (var8_14.isDelegateEventAware()) {
                                    if (var8_14.isEnabledForLevel(var7_13.getLevel())) {
                                        var8_14.log((LoggingEvent)var7_13);
                                    }
                                } else {
                                    Util.report(var9_16);
                                }
                            }
                        }
                        if (var5_9++ != 0) continue;
                        var8_15 = var4_7;
                        var7_13 = var6_12;
                        if (var7_13.getLogger().isDelegateEventAware()) {
                            var9_17 = var8_15;
                            Util.report("A number (" + var9_17 + ") of logging calls during the initialization phase have been intercepted and are");
                            Util.report("now being replayed. These are subject to the filtering rules of the underlying logging system.");
                            Util.report("See also https://www.slf4j.org/codes.html#replay");
                            continue;
                        }
                        if (var7_13.getLogger().isDelegateNOP()) continue;
                        Util.report("The following set of substitute loggers may have been accessed");
                        Util.report("during the initialization phase. Logging calls during this");
                        Util.report("phase were not honored. However, subsequent logging calls to these");
                        Util.report("loggers will work as normally expected.");
                        Util.report("See also https://www.slf4j.org/codes.html#substituteLogger");
                    }
                    var1_1.clear();
                }
            }
            catch (Exception v1) {
                var1_2 = v1;
                var3_5 = v1;
                LoggerFactory.b = 2;
                Util.report("Failed to instantiate SLF4J LoggerFactory", var3_5);
                throw new IllegalStateException("Unexpected initialization failure", var1_2);
            }
        }
    }

    private static /* synthetic */ ServiceLoader b(ClassLoader classLoader) {
        return ServiceLoader.load(SLF4JServiceProvider.class, classLoader);
    }

    static {
        f = new String[]{"2.0"};
    }
}

