/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.io.Closeable;
import java.util.Deque;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPMDCAdapter;
import org.slf4j.helpers.Util;
import org.slf4j.spi.MDCAdapter;
import org.slf4j.spi.SLF4JServiceProvider;

public class MDC {
    private static MDCAdapter a;

    private MDC() {
    }

    public static void put(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (a == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        a.put(string, string2);
    }

    public static MDCCloseable putCloseable(String string, String string2) {
        MDC.put(string, string2);
        return new MDCCloseable(string, 0);
    }

    public static String get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (a == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        return a.get(string);
    }

    public static void remove(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (a == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        a.remove(string);
    }

    public static void clear() {
        if (a == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        a.clear();
    }

    public static Map<String, String> getCopyOfContextMap() {
        if (a == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        return a.getCopyOfContextMap();
    }

    public static void setContextMap(Map<String, String> map) {
        if (a == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        a.setContextMap(map);
    }

    public static MDCAdapter getMDCAdapter() {
        return a;
    }

    public static void pushByKey(String string, String string2) {
        if (a == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        a.pushByKey(string, string2);
    }

    public static String popByKey(String string) {
        if (a == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        return a.popByKey(string);
    }

    public Deque<String> getCopyOfDequeByKey(String string) {
        if (a == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        return a.getCopyOfDequeByKey(string);
    }

    static {
        SLF4JServiceProvider sLF4JServiceProvider = LoggerFactory.b();
        if (sLF4JServiceProvider != null) {
            a = sLF4JServiceProvider.getMDCAdapter();
        } else {
            Util.report("Failed to find provider.");
            Util.report("Defaulting to no-operation MDCAdapter implementation.");
            a = new NOPMDCAdapter();
        }
    }

    public static class MDCCloseable
    implements Closeable {
        private final String a;

        private MDCCloseable(String string) {
            this.a = string;
        }

        @Override
        public void close() {
            MDC.remove(this.a);
        }

        /* synthetic */ MDCCloseable(String string, byte by) {
            this(string);
        }
    }
}

