/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractLogger
implements Serializable,
Logger {
    protected String name;

    @Override
    public String getName() {
        return this.name;
    }

    protected Object readResolve() {
        return LoggerFactory.getLogger(this.getName());
    }

    @Override
    public void trace(String string) {
        if (this.isTraceEnabled()) {
            this.a(Level.TRACE, (Marker)null, string, (Throwable)null);
        }
    }

    @Override
    public void trace(String string, Object object) {
        if (this.isTraceEnabled()) {
            this.a(Level.TRACE, null, string, object);
        }
    }

    @Override
    public void trace(String string, Object object, Object object2) {
        if (this.isTraceEnabled()) {
            this.a(Level.TRACE, null, string, object, object2);
        }
    }

    @Override
    public void trace(String string, Object ... objectArray) {
        if (this.isTraceEnabled()) {
            this.a(Level.TRACE, (Marker)null, string, objectArray);
        }
    }

    @Override
    public void trace(String string, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.a(Level.TRACE, null, string, throwable);
        }
    }

    @Override
    public void trace(Marker marker, String string) {
        if (this.isTraceEnabled(marker)) {
            this.a(Level.TRACE, marker, string, (Throwable)null);
        }
    }

    @Override
    public void trace(Marker marker, String string, Object object) {
        if (this.isTraceEnabled(marker)) {
            this.a(Level.TRACE, marker, string, object);
        }
    }

    @Override
    public void trace(Marker marker, String string, Object object, Object object2) {
        if (this.isTraceEnabled(marker)) {
            this.a(Level.TRACE, marker, string, object, object2);
        }
    }

    @Override
    public void trace(Marker marker, String string, Object ... objectArray) {
        if (this.isTraceEnabled(marker)) {
            this.a(Level.TRACE, marker, string, objectArray);
        }
    }

    @Override
    public void trace(Marker marker, String string, Throwable throwable) {
        if (this.isTraceEnabled(marker)) {
            this.a(Level.TRACE, marker, string, throwable);
        }
    }

    @Override
    public void debug(String string) {
        if (this.isDebugEnabled()) {
            this.a(Level.DEBUG, (Marker)null, string, (Throwable)null);
        }
    }

    @Override
    public void debug(String string, Object object) {
        if (this.isDebugEnabled()) {
            this.a(Level.DEBUG, null, string, object);
        }
    }

    @Override
    public void debug(String string, Object object, Object object2) {
        if (this.isDebugEnabled()) {
            this.a(Level.DEBUG, null, string, object, object2);
        }
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        if (this.isDebugEnabled()) {
            this.a(Level.DEBUG, (Marker)null, string, objectArray);
        }
    }

    @Override
    public void debug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.a(Level.DEBUG, null, string, throwable);
        }
    }

    @Override
    public void debug(Marker marker, String string) {
        if (this.isDebugEnabled(marker)) {
            this.a(Level.DEBUG, marker, string, (Throwable)null);
        }
    }

    @Override
    public void debug(Marker marker, String string, Object object) {
        if (this.isDebugEnabled(marker)) {
            this.a(Level.DEBUG, marker, string, object);
        }
    }

    @Override
    public void debug(Marker marker, String string, Object object, Object object2) {
        if (this.isDebugEnabled(marker)) {
            this.a(Level.DEBUG, marker, string, object, object2);
        }
    }

    @Override
    public void debug(Marker marker, String string, Object ... objectArray) {
        if (this.isDebugEnabled(marker)) {
            this.a(Level.DEBUG, marker, string, objectArray);
        }
    }

    @Override
    public void debug(Marker marker, String string, Throwable throwable) {
        if (this.isDebugEnabled(marker)) {
            this.a(Level.DEBUG, marker, string, throwable);
        }
    }

    @Override
    public void info(String string) {
        if (this.isInfoEnabled()) {
            this.a(Level.INFO, (Marker)null, string, (Throwable)null);
        }
    }

    @Override
    public void info(String string, Object object) {
        if (this.isInfoEnabled()) {
            this.a(Level.INFO, null, string, object);
        }
    }

    @Override
    public void info(String string, Object object, Object object2) {
        if (this.isInfoEnabled()) {
            this.a(Level.INFO, null, string, object, object2);
        }
    }

    @Override
    public void info(String string, Object ... objectArray) {
        if (this.isInfoEnabled()) {
            this.a(Level.INFO, (Marker)null, string, objectArray);
        }
    }

    @Override
    public void info(String string, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.a(Level.INFO, null, string, throwable);
        }
    }

    @Override
    public void info(Marker marker, String string) {
        if (this.isInfoEnabled(marker)) {
            this.a(Level.INFO, marker, string, (Throwable)null);
        }
    }

    @Override
    public void info(Marker marker, String string, Object object) {
        if (this.isInfoEnabled(marker)) {
            this.a(Level.INFO, marker, string, object);
        }
    }

    @Override
    public void info(Marker marker, String string, Object object, Object object2) {
        if (this.isInfoEnabled(marker)) {
            this.a(Level.INFO, marker, string, object, object2);
        }
    }

    @Override
    public void info(Marker marker, String string, Object ... objectArray) {
        if (this.isInfoEnabled(marker)) {
            this.a(Level.INFO, marker, string, objectArray);
        }
    }

    @Override
    public void info(Marker marker, String string, Throwable throwable) {
        if (this.isInfoEnabled(marker)) {
            this.a(Level.INFO, marker, string, throwable);
        }
    }

    @Override
    public void warn(String string) {
        if (this.isWarnEnabled()) {
            this.a(Level.WARN, (Marker)null, string, (Throwable)null);
        }
    }

    @Override
    public void warn(String string, Object object) {
        if (this.isWarnEnabled()) {
            this.a(Level.WARN, null, string, object);
        }
    }

    @Override
    public void warn(String string, Object object, Object object2) {
        if (this.isWarnEnabled()) {
            this.a(Level.WARN, null, string, object, object2);
        }
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        if (this.isWarnEnabled()) {
            this.a(Level.WARN, (Marker)null, string, objectArray);
        }
    }

    @Override
    public void warn(String string, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.a(Level.WARN, null, string, throwable);
        }
    }

    @Override
    public void warn(Marker marker, String string) {
        if (this.isWarnEnabled(marker)) {
            this.a(Level.WARN, marker, string, (Throwable)null);
        }
    }

    @Override
    public void warn(Marker marker, String string, Object object) {
        if (this.isWarnEnabled(marker)) {
            this.a(Level.WARN, marker, string, object);
        }
    }

    @Override
    public void warn(Marker marker, String string, Object object, Object object2) {
        if (this.isWarnEnabled(marker)) {
            this.a(Level.WARN, marker, string, object, object2);
        }
    }

    @Override
    public void warn(Marker marker, String string, Object ... objectArray) {
        if (this.isWarnEnabled(marker)) {
            this.a(Level.WARN, marker, string, objectArray);
        }
    }

    @Override
    public void warn(Marker marker, String string, Throwable throwable) {
        if (this.isWarnEnabled(marker)) {
            this.a(Level.WARN, marker, string, throwable);
        }
    }

    @Override
    public void error(String string) {
        if (this.isErrorEnabled()) {
            this.a(Level.ERROR, (Marker)null, string, (Throwable)null);
        }
    }

    @Override
    public void error(String string, Object object) {
        if (this.isErrorEnabled()) {
            this.a(Level.ERROR, null, string, object);
        }
    }

    @Override
    public void error(String string, Object object, Object object2) {
        if (this.isErrorEnabled()) {
            this.a(Level.ERROR, null, string, object, object2);
        }
    }

    @Override
    public void error(String string, Object ... objectArray) {
        if (this.isErrorEnabled()) {
            this.a(Level.ERROR, (Marker)null, string, objectArray);
        }
    }

    @Override
    public void error(String string, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.a(Level.ERROR, null, string, throwable);
        }
    }

    @Override
    public void error(Marker marker, String string) {
        if (this.isErrorEnabled(marker)) {
            this.a(Level.ERROR, marker, string, (Throwable)null);
        }
    }

    @Override
    public void error(Marker marker, String string, Object object) {
        if (this.isErrorEnabled(marker)) {
            this.a(Level.ERROR, marker, string, object);
        }
    }

    @Override
    public void error(Marker marker, String string, Object object, Object object2) {
        if (this.isErrorEnabled(marker)) {
            this.a(Level.ERROR, marker, string, object, object2);
        }
    }

    @Override
    public void error(Marker marker, String string, Object ... objectArray) {
        if (this.isErrorEnabled(marker)) {
            this.a(Level.ERROR, marker, string, objectArray);
        }
    }

    @Override
    public void error(Marker marker, String string, Throwable throwable) {
        if (this.isErrorEnabled(marker)) {
            this.a(Level.ERROR, marker, string, throwable);
        }
    }

    private void a(Level level, Marker marker, String string, Throwable throwable) {
        this.handleNormalizedLoggingCall(level, marker, string, null, throwable);
    }

    private void a(Level level, Marker marker, String string, Object object) {
        this.handleNormalizedLoggingCall(level, marker, string, new Object[]{object}, null);
    }

    private void a(Level level, Marker marker, String string, Object object, Object object2) {
        if (object2 instanceof Throwable) {
            this.handleNormalizedLoggingCall(level, marker, string, new Object[]{object}, (Throwable)object2);
            return;
        }
        this.handleNormalizedLoggingCall(level, marker, string, new Object[]{object, object2}, null);
    }

    private void a(Level level, Marker marker, String string, Object[] objectArray) {
        Throwable throwable = MessageFormatter.getThrowableCandidate(objectArray);
        if (throwable != null) {
            objectArray = MessageFormatter.trimmedCopy(objectArray);
            this.handleNormalizedLoggingCall(level, marker, string, objectArray, throwable);
            return;
        }
        this.handleNormalizedLoggingCall(level, marker, string, objectArray, null);
    }

    protected abstract String getFullyQualifiedCallerName();

    protected abstract void handleNormalizedLoggingCall(Level var1, Marker var2, String var3, Object[] var4, Throwable var5);
}

