/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.NormalizedParameters;
import org.slf4j.helpers.Util;

public final class MessageFormatter {
    public static final FormattingTuple format(String string, Object object) {
        return MessageFormatter.arrayFormat(string, new Object[]{object});
    }

    public static final FormattingTuple format(String string, Object object, Object object2) {
        return MessageFormatter.arrayFormat(string, new Object[]{object, object2});
    }

    public static final FormattingTuple arrayFormat(String string, Object[] objectArray) {
        Throwable throwable = MessageFormatter.getThrowableCandidate(objectArray);
        Object[] objectArray2 = objectArray;
        if (throwable != null) {
            objectArray2 = MessageFormatter.trimmedCopy(objectArray);
        }
        return MessageFormatter.arrayFormat(string, objectArray2, throwable);
    }

    public static final String basicArrayFormat(String object, Object[] objectArray) {
        object = MessageFormatter.arrayFormat((String)object, objectArray, null);
        return ((FormattingTuple)object).getMessage();
    }

    public static String basicArrayFormat(NormalizedParameters normalizedParameters) {
        return MessageFormatter.basicArrayFormat(normalizedParameters.getMessage(), normalizedParameters.getArguments());
    }

    public static final FormattingTuple arrayFormat(String string, Object[] objectArray, Throwable throwable) {
        if (string == null) {
            return new FormattingTuple(null, objectArray, throwable);
        }
        if (objectArray == null) {
            return new FormattingTuple(string);
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            char c2;
            int n3 = string.indexOf("{}", n2);
            if (n3 == -1) {
                if (n2 == 0) {
                    return new FormattingTuple(string, objectArray, throwable);
                }
                stringBuilder.append(string, n2, string.length());
                return new FormattingTuple(stringBuilder.toString(), objectArray, throwable);
            }
            int n4 = n3;
            String string2 = string;
            if (n4 != 0 && (c2 = string2.charAt(n4 - 1)) == '\\') {
                n4 = n3;
                String string3 = string;
                if (!(n4 >= 2 && string3.charAt(n4 - 2) == '\\')) {
                    --i2;
                    stringBuilder.append(string, n2, n3 - 1);
                    stringBuilder.append('{');
                    n2 = n3 + 1;
                    continue;
                }
                stringBuilder.append(string, n2, n3 - 1);
                MessageFormatter.a(stringBuilder, objectArray[i2], new HashMap<Object[], Object>());
                n2 = n3 + 2;
                continue;
            }
            stringBuilder.append(string, n2, n3);
            MessageFormatter.a(stringBuilder, objectArray[i2], new HashMap<Object[], Object>());
            n2 = n3 + 2;
        }
        stringBuilder.append(string, n2, string.length());
        return new FormattingTuple(stringBuilder.toString(), objectArray, throwable);
    }

    private static void a(StringBuilder stringBuilder, Object object, Map<Object[], Object> map) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (!object.getClass().isArray()) {
            MessageFormatter.a(stringBuilder, object);
            return;
        }
        if (object instanceof boolean[]) {
            MessageFormatter.a(stringBuilder, (boolean[])object);
            return;
        }
        if (object instanceof byte[]) {
            MessageFormatter.a(stringBuilder, (byte[])object);
            return;
        }
        if (object instanceof char[]) {
            MessageFormatter.a(stringBuilder, (char[])object);
            return;
        }
        if (object instanceof short[]) {
            MessageFormatter.a(stringBuilder, (short[])object);
            return;
        }
        if (object instanceof int[]) {
            MessageFormatter.a(stringBuilder, (int[])object);
            return;
        }
        if (object instanceof long[]) {
            MessageFormatter.a(stringBuilder, (long[])object);
            return;
        }
        if (object instanceof float[]) {
            MessageFormatter.a(stringBuilder, (float[])object);
            return;
        }
        if (object instanceof double[]) {
            MessageFormatter.a(stringBuilder, (double[])object);
            return;
        }
        MessageFormatter.a(stringBuilder, (Object[])object, map);
    }

    private static void a(StringBuilder stringBuilder, Object object) {
        try {
            String string = object.toString();
            stringBuilder.append(string);
            return;
        }
        catch (Throwable throwable) {
            Util.report("SLF4J: Failed toString() invocation on an object of type [" + object.getClass().getName() + "]", throwable);
            stringBuilder.append("[FAILED toString()]");
            return;
        }
    }

    private static void a(StringBuilder stringBuilder, Object[] objectArray, Map<Object[], Object> map) {
        stringBuilder.append('[');
        if (!map.containsKey(objectArray)) {
            map.put(objectArray, null);
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MessageFormatter.a(stringBuilder, objectArray[i2], map);
                if (i2 == n2 - 1) continue;
                stringBuilder.append(", ");
            }
            map.remove(objectArray);
        } else {
            stringBuilder.append("...");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, boolean[] blArray) {
        stringBuilder.append('[');
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(blArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, byte[] byArray) {
        stringBuilder.append('[');
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(byArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, char[] cArray) {
        stringBuilder.append('[');
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(cArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, short[] sArray) {
        stringBuilder.append('[');
        int n2 = sArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(sArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, int[] nArray) {
        stringBuilder.append('[');
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(nArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, long[] lArray) {
        stringBuilder.append('[');
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(lArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, float[] fArray) {
        stringBuilder.append('[');
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(fArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, double[] dArray) {
        stringBuilder.append('[');
        int n2 = dArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(dArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    public static Throwable getThrowableCandidate(Object[] objectArray) {
        return NormalizedParameters.getThrowableCandidate(objectArray);
    }

    public static Object[] trimmedCopy(Object[] objectArray) {
        return NormalizedParameters.trimmedCopy(objectArray);
    }
}

