/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.spi;

import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.DefaultLoggingEvent;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;

public class DefaultLoggingEventBuilder
implements CallerBoundaryAware,
LoggingEventBuilder {
    private static String a = DefaultLoggingEventBuilder.class.getName();
    protected DefaultLoggingEvent loggingEvent;
    protected Logger logger;

    public DefaultLoggingEventBuilder(Logger logger, Level level) {
        this.logger = logger;
        this.loggingEvent = new DefaultLoggingEvent(level, logger);
    }

    @Override
    public LoggingEventBuilder addMarker(Marker marker) {
        this.loggingEvent.addMarker(marker);
        return this;
    }

    @Override
    public LoggingEventBuilder setCause(Throwable throwable) {
        this.loggingEvent.setThrowable(throwable);
        return this;
    }

    @Override
    public LoggingEventBuilder addArgument(Object object) {
        this.loggingEvent.addArgument(object);
        return this;
    }

    @Override
    public LoggingEventBuilder addArgument(Supplier<?> supplier) {
        this.loggingEvent.addArgument(supplier.get());
        return this;
    }

    @Override
    public void setCallerBoundary(String string) {
        this.loggingEvent.setCallerBoundary(string);
    }

    @Override
    public void log() {
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    @Override
    public LoggingEventBuilder setMessage(String string) {
        this.loggingEvent.setMessage(string);
        return this;
    }

    @Override
    public LoggingEventBuilder setMessage(Supplier<String> supplier) {
        this.loggingEvent.setMessage(supplier.get());
        return this;
    }

    @Override
    public void log(String string) {
        this.loggingEvent.setMessage(string);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    @Override
    public void log(String string, Object object) {
        this.loggingEvent.setMessage(string);
        this.loggingEvent.addArgument(object);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    @Override
    public void log(String string, Object object, Object object2) {
        this.loggingEvent.setMessage(string);
        this.loggingEvent.addArgument(object);
        this.loggingEvent.addArgument(object2);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    @Override
    public void log(String string, Object ... objectArray) {
        this.loggingEvent.setMessage(string);
        this.loggingEvent.addArguments(objectArray);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    @Override
    public void log(Supplier<String> supplier) {
        if (supplier == null) {
            this.log((String)null);
            return;
        }
        this.log(supplier.get());
    }

    protected void log(LoggingEvent object) {
        String string;
        this.setCallerBoundary(a);
        if (this.logger instanceof LoggingEventAware) {
            ((LoggingEventAware)((Object)this.logger)).log((LoggingEvent)object);
            return;
        }
        Object loggingEvent = object;
        object = this;
        Object object2 = loggingEvent.getArgumentArray();
        int n2 = object2 == null ? 0 : ((Object[])object2).length;
        Serializable serializable = loggingEvent.getThrowable();
        int n3 = serializable == null ? 0 : 1;
        Iterator<KeyValuePair> iterator = loggingEvent.getMessage();
        Object[] objectArray = new Object[n2 + n3];
        if (object2 != null) {
            System.arraycopy(object2, 0, objectArray, 0, n2);
        }
        if (serializable != null) {
            objectArray[n2] = serializable;
        }
        String string2 = iterator;
        object2 = loggingEvent;
        serializable = null;
        if (object2.getMarkers() != null) {
            serializable = new StringBuilder();
            for (Marker object3 : object2.getMarkers()) {
                ((StringBuilder)serializable).append(object3);
                ((StringBuilder)serializable).append(' ');
            }
        }
        if (object2.getKeyValuePairs() != null) {
            if (serializable == null) {
                serializable = new StringBuilder();
            }
            for (KeyValuePair keyValuePair : object2.getKeyValuePairs()) {
                ((StringBuilder)serializable).append(keyValuePair.key);
                ((StringBuilder)serializable).append('=');
                ((StringBuilder)serializable).append(keyValuePair.value);
                ((StringBuilder)serializable).append(' ');
            }
        }
        if (serializable != null) {
            ((StringBuilder)serializable).append(string2);
            string = ((StringBuilder)serializable).toString();
        } else {
            string = string2;
        }
        iterator = string;
        switch (loggingEvent.getLevel()) {
            case TRACE: {
                ((DefaultLoggingEventBuilder)object).logger.trace((String)((Object)iterator), objectArray);
                return;
            }
            case DEBUG: {
                ((DefaultLoggingEventBuilder)object).logger.debug((String)((Object)iterator), objectArray);
                return;
            }
            case INFO: {
                ((DefaultLoggingEventBuilder)object).logger.info((String)((Object)iterator), objectArray);
                return;
            }
            case WARN: {
                ((DefaultLoggingEventBuilder)object).logger.warn((String)((Object)iterator), objectArray);
                return;
            }
            case ERROR: {
                ((DefaultLoggingEventBuilder)object).logger.error((String)((Object)iterator), objectArray);
            }
        }
    }

    @Override
    public LoggingEventBuilder addKeyValue(String string, Object object) {
        this.loggingEvent.addKeyValue(string, object);
        return this;
    }

    @Override
    public LoggingEventBuilder addKeyValue(String string, Supplier<Object> supplier) {
        this.loggingEvent.addKeyValue(string, supplier.get());
        return this;
    }
}

